<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Diary extends MY_Controller
{

    function __construct() {
        parent::__construct();

        if (!$this->loggedIn) {
            redirect('login');
        }
        if ( ! $this->session->userdata('store_id')) {
            $this->session->set_flashdata('warning', lang("please_select_store"));
            redirect('stores');
        }
        $this->load->library('form_validation');
        $this->load->model('diary_model');
        $this->allowed_types = 'gif|jpg|png|pdf|doc|docx|xls|xlsx|zip';
    }

 
function diary($id = NULL) {

        $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['page_title'] = lang('diary');
        $bc = array(array('link' => site_url('diary'), 'page' => lang('diary')), array('link' => '#', 'page' => lang('diary')));
        $meta = array('page_title' => lang('diary'), 'bc' => $bc);
        $this->page_construct('diary/diary', $this->data, $meta);

    }

    function get_diary($user_id = NULL) {
    
    $start_date = $this->input->get('start_date') ? $this->input->get('start_date') : NULL;
        $end_date = $this->input->get('end_date') ? $this->input->get('end_date') : NULL;
        


        $detail_link = anchor('diary/diary_note/$1', '<i class="fa fa-file-text-o"></i> ' . lang('diary_note'), 'data-toggle="modal" data-target="#myModal2"');
        $edit_link = anchor('diary/edit_diary/$1', '<i class="fa fa-edit"></i> ' . lang('edit_diary'), 'data-toggle="modal" data-target="#myModal"');
        $delete_link = "<a href='#' class='po' title='<b>" . $this->lang->line("delete_diary") . "</b>' data-content=\"<p>"
            . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . site_url('diary/delete_diary/$1') . "'>"
            . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\"  rel='popover'><i class=\"fa fa-trash-o\"></i> "
            . lang('delete_diary') . "</a>";
        $action = '<div class="text-center"><div class="btn-group text-left">'
            . '<button type="button" class="btn btn-default btn-xs btn-primary dropdown-toggle" data-toggle="dropdown">'
            . lang('actions') . ' <span class="caret"></span></button>
        <ul class="dropdown-menu pull-right" role="menu">
            <li>' . $detail_link . '</li>
            <li>' . $edit_link . '</li>
            <li>' . $delete_link . '</li>
        </ul>
    </div></div>';

        $this->load->library('datatables');
        if ($this->db->dbdriver == 'sqlite3') {
            $this->datatables->select($this->db->dbprefix('diary') . ".id as id, date, note, (" . $this->db->dbprefix('users') . ".first_name || ' ' || " . $this->db->dbprefix('users') . ".last_name) as user, attachment", FALSE);
        } else {
            $this->datatables->select($this->db->dbprefix('diary') . ".id as id, date, note, CONCAT(" . $this->db->dbprefix('users') . ".first_name, ' ', " . $this->db->dbprefix('users') . ".last_name) as user, attachment", FALSE);
        }
        $this->datatables->from('diary')
            ->join('users', 'users.id=diary.created_by', 'left')
            ->group_by('diary.id');

        if (!$this->Admin && !$this->session->userdata('view_right')) {
            $this->datatables->where('created_by', $this->session->userdata('user_id'));
        }
        if($start_date) { $this->datatables->where('date >=', $start_date); }
        if($end_date) { $this->datatables->where('date <=', $end_date); }
        $this->datatables->add_column("Actions", "<div class='text-center'><div class='btn-group'><a href='".site_url('diary/diary_note/$1')."' title='".lang('diary_note')."' class='tip btn btn-primary btn-xs' data-toggle='ajax-modal'><i class='fa fa-file-text-o'></i></a> <a href='" . site_url('diary/edit_diary/$1') . "' title='" . lang("edit_diary") . "' class='tip btn btn-warning btn-xs'><i class='fa fa-edit'></i></a> <a href='" . site_url('diary/delete_diary/$1') . "' onClick=\"return confirm('" . lang('alert_x_diary') . "')\" title='" . lang("delete_diary") . "' class='tip btn btn-danger btn-xs'><i class='fa fa-trash-o'></i></a></div></div>", "id");
        $this->datatables->unset_column('id');
        echo $this->datatables->generate();
    }

    function diary_note($id = NULL) {
        if ( ! $this->Admin) {
            if($diary->created_by != $this->session->userdata('user_id')) {
                $this->session->set_flashdata('error', lang('access_denied'));
                redirect(isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : 'pos');
            }
        }

        $diary = $this->diary_model->getdiaryByID($id);
        $this->data['user'] = $this->site->getUser($diary->created_by);
        $this->data['diary'] = $diary;
        $this->data['page_title'] = $this->lang->line("diary_note");
        $this->load->view($this->theme . 'diary/diary_note', $this->data);

    }

    function add_diary() {
        if ( ! $this->session->userdata('store_id')) {
            $this->session->set_flashdata('warning', lang("please_select_store"));
            redirect('stores');
        }
        $this->load->helper('security');

        $this->form_validation->set_rules('userfile', lang("attachment"), 'xss_clean');
        if ($this->form_validation->run() == true) {
            if ($this->Admin) {
                $date = trim($this->input->post('date'));
            } else {
                $date = date('Y-m-d H:i:s');
            }
            $data = array(
                'date' => $date,
                'created_by' => $this->session->userdata('user_id'),
                'note' => $this->input->post('note', TRUE)
            );

            if ($_FILES['userfile']['size'] > 0) {
                $this->load->library('upload');
                $config['upload_path'] = 'uploads/';
                $config['allowed_types'] = $this->allowed_types;
                $config['max_size'] = '2000';
                $config['overwrite'] = FALSE;
                $config['encrypt_name'] = TRUE;
                $this->upload->initialize($config);
                if (!$this->upload->do_upload()) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    redirect($_SERVER["HTTP_REFERER"]);
                }
                $photo = $this->upload->file_name;
                $data['attachment'] = $photo;
            }

            //$this->tec->print_arrays($data);

        } elseif ($this->input->post('add_diary')) {
            $this->session->set_flashdata('error', validation_errors());
            redirect($_SERVER["HTTP_REFERER"]);
        }

        if ($this->form_validation->run() == true && $this->diary_model->adddiary($data)) {

            $this->session->set_flashdata('message', lang("diary_added"));
            redirect('diary/diary');

        } else {

            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['page_title'] = lang('add_diary');
            $bc = array(array('link' => site_url('diary'), 'page' => lang('diary')), array('link' => site_url('diary/diary'), 'page' => lang('diary')), array('link' => '#', 'page' => lang('add_diary')));
            $meta = array('page_title' => lang('add_diary'), 'bc' => $bc);
            $this->page_construct('diary/add_diary', $this->data, $meta);

        }
    }

    function edit_diary($id = NULL) {
      /*  if ( ! $this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }*/
        $this->load->helper('security');
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        
        
        $this->form_validation->set_rules('userfile', lang("attachment"), 'xss_clean');
        if ($this->form_validation->run() == true) {
            if ($this->Admin) {
                $date = trim($this->input->post('date'));
            } else {
                $date = date('Y-m-d H:i:s');
            }
            $data = array(
                'date' => $date,
                'note' => $this->input->post('note', TRUE)
            );
            if ($_FILES['userfile']['size'] > 0) {
                $this->load->library('upload');
                $config['upload_path'] = 'uploads/';
                $config['allowed_types'] = $this->allowed_types;
                $config['max_size'] = '2000';
                $config['overwrite'] = FALSE;
                $config['encrypt_name'] = TRUE;
                $this->upload->initialize($config);
                if (!$this->upload->do_upload()) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    redirect($_SERVER["HTTP_REFERER"]);
                }
                $photo = $this->upload->file_name;
                $data['attachment'] = $photo;
            }

            //$this->tec->print_arrays($data);

        } elseif ($this->input->post('edit_diary')) {
            $this->session->set_flashdata('error', validation_errors());
            redirect($_SERVER["HTTP_REFERER"]);
        }


        if ($this->form_validation->run() == true && $this->diary_model->updatediary($id, $data)) {
            $this->session->set_flashdata('message', lang("diary_updated"));
            redirect("diary/diary");
        } else {

            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['diary'] = $this->diary_model->getdiaryByID($id);
            $this->data['page_title'] = lang('edit_diary');
            $bc = array(array('link' => site_url('diary'), 'page' => lang('diary')), array('link' => site_url('diary/diary'), 'page' => lang('diary')), array('link' => '#', 'page' => lang('edit_diary')));
            $meta = array('page_title' => lang('edit_diary'), 'bc' => $bc);
            $this->page_construct('diary/edit_diary', $this->data, $meta);

        }
    }

    function delete_diary($id = NULL) {
        if(DEMO) {
            $this->session->set_flashdata('error', lang('disabled_in_demo'));
            redirect(isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : 'welcome');
        }
       /* if ( ! $this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }*/
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        $diary = $this->diary_model->getdiaryByID($id);
        if ($this->diary_model->deletediary($id)) {
            if ($diary->attachment) {
                unlink($this->upload_path . $diary->attachment);
            }
            $this->session->set_flashdata('message', lang("diary_deleted"));
            redirect('diary/diary');
        }
    }
}
