<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Reports_model extends CI_Model
{

    public function __construct() {
        parent::__construct();
    }

    public function getAllProducts() {
        $q = $this->db->get('products');
        if($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
    
     public function getAllProductsWithCat() {
         $this->db->select('tec_products.id, tec_products.name as pname, tec_categories.name as cname', FALSE)
        ->join('tec_categories', 'tec_categories.id =tec_products.category_id', 'left');
        $q = $this->db->get('products');
        if($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
    
    
      public function getTodayPresentSale($date)
    {
    	$todaydate = $date ? $date : date("Y-m-d");
        $this->db->select('SUM(COALESCE(paid, 0)) as paid', FALSE);
        if ($this->session->userdata('store_id')) {
            $this->db->where('store_id', $this->session->userdata('store_id'));
        }
        $this->db->where('DATE(tec_sales.date)',$todaydate);
        $q = $this->db->get('sales');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    
    }
      public function getTodayPresentProfit($date)
    {
        $todaydate = $date ? $date : date("Y-m-d");
        $this->db->select('SUM(tec_sale_items.cost* tec_sale_items.quantity) as costtotal, SUM(tec_sale_items.subtotal) as pricetotal', FALSE)
        ->join('tec_sale_items', 'tec_sale_items.sale_id = tec_sales.id', 'left');
        
        if ($this->session->userdata('store_id')) {
            $this->db->where('store_id', $this->session->userdata('store_id'));
        }
        $this->db->where('DATE(tec_sales.date)',$todaydate);
        $q = $this->db->get('sales');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    
    }
   
      public function getMonthlyPresentProfit($date)
    {
        $todaydate = $date ? $date : date("Y-m");
        $this->db->select('SUM(tec_sale_items.cost* tec_sale_items.quantity) as costtotal, SUM(tec_sale_items.subtotal) as pricetotal', FALSE)
        ->join('tec_sale_items', 'tec_sale_items.sale_id = tec_sales.id', 'left');
        
        if ($this->session->userdata('store_id')) {
            $this->db->where('store_id', $this->session->userdata('store_id'));
        }
       
        $this->db->like('tec_sales.date', "{$todaydate}", 'after');
        $q = $this->db->get('sales');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    
    }
    
    
    public function getMonthlyExpense($date)
    {
        $todaydate = $date ? $date : date("Y-m");
        $this->db->select('SUM(tec_expenses.amount) as totalexpense', FALSE);
        
        if ($this->session->userdata('store_id')) {
            $this->db->where('store_id', $this->session->userdata('store_id'));
        }
        $this->db->like('tec_expenses.date', "{$todaydate}", 'after');
        $q = $this->db->get('tec_expenses');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    
    }
    public function getTodayExpenses($date)
    {
        $todaydate = $date ? $date : date("Y-m-d");
        $this->db->select('SUM(tec_expenses.amount) as totalexpense', FALSE);
        
        if ($this->session->userdata('store_id')) {
            $this->db->where('store_id', $this->session->userdata('store_id'));
        }
        $this->db->where('DATE(tec_expenses.date)',$todaydate);
        $q = $this->db->get('tec_expenses');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    
    }
    public function getTodayDebt($date)
    {
        $todaydate = $date ? $date : date("Y-m-d");
        $this->db->select('SUM(total-paid) as debt', FALSE);
        
        if ($this->session->userdata('store_id')) {
            $this->db->where('store_id', $this->session->userdata('store_id'));
        }
        $this->db->where('DATE(tec_sales.date)',$todaydate);
        $q = $this->db->get('tec_sales');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    
    }
    
 
    public function getTodaySale($start_date = NULL, $end_date = NULL)
    { 
    if ($start_date && $end_date) {
    $todaydate = date("Y-m-d", strtotime($start_date));
   // $myQuery = "SELECT amount FROM `tec_income` WHERE MONTH(date) = MONTH('".$todaydate."') and type_id = 7 ";
    $myQuery = "SELECT SUM(paid) as totalsale FROM `tec_sales` WHERE  date BETWEEN '".$start_date."' AND '".$end_date."'";
    }else{
   $todaydate = date("Y-m-d");
   $myQuery = "SELECT SUM(paid) as totalsale FROM `tec_sales` WHERE  date LIKE '%".$todaydate."%'";
   // $myQuery = "SELECT amount FROM `tec_income` WHERE type_id = 7 ";
 }
// print $myQuery;
       $q = $this->db->query($myQuery);
		if($q->num_rows() > 0) {
			foreach (($q->result()) as $row) {
				$data[] = $row;
			}
			
			return $data;
			
		}
		return FALSE;
	}
	
	
	
	public function getexpense($start_date = NULL, $end_date = NULL)
    {
    if ($start_date && $end_date) {
    $myQuery = "SELECT tec_expenses.reference as name, SUM(tec_expenses.amount) as amount FROM `tec_expenses`  WHERE tec_expenses.date BETWEEN '".$start_date."' AND '".$end_date."' ";
    
    }else{
    $todaydate = date("Y-m-d");
    $myQuery = "SELECT tec_expenses.reference as name, SUM(tec_expenses.amount) as amount FROM `tec_expenses`  WHERE tec_expenses.date LIKE '%".$todaydate."%' ";
    }
   // print  $myQuery;
       $q = $this->db->query($myQuery);
		
			if($q->num_rows() > 0) {
			foreach (($q->result()) as $row) {
				$data[] = $row;
			}
			
			return $data;
			
		}
			
			
		
		return FALSE;
	}
	
    public function getAllCategories() {
        $q = $this->db->get('categories');
        if($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
     public function getAllCategories_byid($parent_id) {
     	$this->db->where('parent_id', $parent_id);
        $q = $this->db->get('categories');
         
        if($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function getAllCustomers() {
        $this->db->order_by("name", 'asc');
        $q = $this->db->get('customers');
        if($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
    
   

    public function topProductsbyCatID($catid = NULL) {
        $m = date('Y-m');
        $this->db->select($this->db->dbprefix('products').".code as product_code, ".$this->db->dbprefix('products').".name as product_name, sum(".$this->db->dbprefix('sale_items').".quantity) as quantity")
        ->join('products', 'products.id=sale_items.product_id', 'left')
        ->join('sales', 'sales.id=sale_items.sale_id', 'left')
        ->order_by("sum(".$this->db->dbprefix('sale_items').".quantity)", 'desc')
        ->group_by('sale_items.product_id')
        ->limit(10)
        ->like($this->db->dbprefix('sales').'.date', $m, 'both');
        $this->db->where_in('tec_products.category_id', $catid);
        if ($this->session->userdata('store_id')) {
            $this->db->where('store_id', $this->session->userdata('store_id'));
        }
        $q = $this->db->get('sale_items');
      //$this->db->save_queries = TRUE;
      //$str = $this->db->last_query();
     // echo $str;
        if($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }
     public function topProducts() {
        $m = date('Y-m');
        $this->db->select($this->db->dbprefix('products').".code as product_code, ".$this->db->dbprefix('products').".name as product_name, sum(".$this->db->dbprefix('sale_items').".quantity) as quantity")
        ->join('products', 'products.id=sale_items.product_id', 'left')
        ->join('sales', 'sales.id=sale_items.sale_id', 'left')
        ->order_by("sum(".$this->db->dbprefix('sale_items').".quantity)", 'desc')
        ->group_by('sale_items.product_id')
        ->limit(10)
        ->like($this->db->dbprefix('sales').'.date', $m, 'both');
        if ($this->session->userdata('store_id')) {
            $this->db->where('store_id', $this->session->userdata('store_id'));
        }
        $q = $this->db->get('sale_items');
        if($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function topProducts1($catid) {
        $m = date('Y-m', strtotime('first day of last month'));
        $this->db->select($this->db->dbprefix('products').".code as product_code, ".$this->db->dbprefix('products').".name as product_name, sum(".$this->db->dbprefix('sale_items').".quantity) as quantity")
        ->join('products', 'products.id=sale_items.product_id', 'left')
        ->join('sales', 'sales.id=sale_items.sale_id', 'left')
        ->order_by("sum(".$this->db->dbprefix('sale_items').".quantity)", 'desc')
        ->group_by('sale_items.product_id')
        ->limit(10)
        ->like($this->db->dbprefix('sales').'.date', $m, 'both');
        $this->db->where_in('tec_products.category_id', $catid);
        if ($this->session->userdata('store_id')) {
            $this->db->where('store_id', $this->session->userdata('store_id'));
        }
        $q = $this->db->get('sale_items');
        //  $this->db->save_queries = TRUE;
      //$str = $this->db->last_query();
      //echo $str;
        if($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function topProducts3() {
        $this->db->select($this->db->dbprefix('products').".code as product_code, ".$this->db->dbprefix('products').".name as product_name, sum(".$this->db->dbprefix('sale_items').".quantity) as quantity")
        ->join('products', 'products.id=sale_items.product_id', 'left')
        ->join('sales', 'sales.id=sale_items.sale_id', 'left')
        ->order_by("sum(".$this->db->dbprefix('sale_items').".quantity)", 'desc')
        ->group_by('sale_items.product_id')
        ->limit(10);
        if ($this->db->dbdriver == 'sqlite3') {
            // ->where("date >= datetime('now','-6 month')", NULL, FALSE)
            $this->db->where("{$this->db->dbprefix('sales')}.date >= datetime(date('now','start of month','+1 month','-1 day'), '-3 month')", NULL, FALSE);
        } else {
            $this->db->where($this->db->dbprefix('sales').'.date >= last_day(now()) + interval 1 day - interval 3 month', NULL, FALSE);
        }
        if ($this->session->userdata('store_id')) {
            $this->db->where('store_id', $this->session->userdata('store_id'));
        }
        $q = $this->db->get('sale_items');
        if($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function topProducts12() {
        $this->db->select($this->db->dbprefix('products').".code as product_code, ".$this->db->dbprefix('products').".name as product_name, sum(".$this->db->dbprefix('sale_items').".quantity) as quantity")
        ->join('products', 'products.id=sale_items.product_id', 'left')
        ->join('sales', 'sales.id=sale_items.sale_id', 'left')
        ->order_by("sum(".$this->db->dbprefix('sale_items').".quantity)", 'desc')
        ->group_by('sale_items.product_id')
        ->limit(10);
        if ($this->db->dbdriver == 'sqlite3') {
            // ->where("date >= datetime('now','-6 month')", NULL, FALSE)
            $this->db->where("{$this->db->dbprefix('sales')}.date >= datetime(date('now','start of month','+1 month','-1 day'), '-12 month')", NULL, FALSE);
        } else {
            $this->db->where($this->db->dbprefix('sales').'.date >= last_day(now()) + interval 1 day - interval 12 month', NULL, FALSE);
        }

        if ($this->session->userdata('store_id')) {
            $this->db->where('store_id', $this->session->userdata('store_id'));
        }
        $q = $this->db->get('sale_items');
        if($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
    }

    
    
    
  public function getDailyProfit($year, $month)
    {
        if ($this->db->dbdriver == 'sqlite3') {
            $this->db->select("strftime('%d', date) AS date, COALESCE(sum(product_tax), 0) as product_tax, COALESCE(sum(order_tax), 0) as order_tax, COALESCE(sum(total), 0) as total, COALESCE(sum(grand_total), 0) as grand_total, COALESCE(sum(total_tax), 0) as total_tax, COALESCE(sum(rounding), 0) as rounding, COALESCE(sum(total_discount), 0) as discount, COALESCE(sum(paid), 0) as paid", FALSE)->group_by("strftime('%d', date)");
        } else {
            $this->db->select("DATE_FORMAT(date,  '%d') AS date, COALESCE(sum(product_tax), 0) as product_tax, COALESCE(sum(order_tax), 0) as order_tax, COALESCE(sum(total), 0) as total, COALESCE(sum(grand_total), 0) as grand_total, COALESCE(sum(total_tax), 0) as total_tax, COALESCE(sum(rounding), 0) as rounding, COALESCE(sum(total_discount), 0) as discount, COALESCE(sum(paid), 0) as paid", FALSE)->group_by("DATE_FORMAT(date, '%d')");
        }
        $this->db->like('date', "{$year}-{$month}", 'after');
        if ($this->session->userdata('store_id')) {
            $this->db->where('store_id', $this->session->userdata('store_id'));
        }
        $q = $this->db->get('sales');
         
        if($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
        
         
    }

    public function getMonthlySales($year) {
        if ($this->db->dbdriver == 'sqlite3') {
            $this->db->select("strftime('%m', date) AS date, strftime('%Y-%m', date) AS fulldate, COALESCE(sum(product_tax), 0) as product_tax, COALESCE(sum(order_tax), 0) as order_tax, COALESCE(sum(total), 0) as total, COALESCE(sum(grand_total), 0) as grand_total, COALESCE(sum(total_tax), 0) as tax, COALESCE(sum(total_discount), 0) as discount, COALESCE(sum(paid), 0) as paid", FALSE)
            ->group_by("strftime('%m', date)")
            ->order_by("strftime('%m', date) ASC");
        } else {
            $this->db->select("DATE_FORMAT( date,  '%m' ) AS date, DATE_FORMAT( date,  '%Y-%m' ) AS fulldate, COALESCE(sum(product_tax), 0) as product_tax, COALESCE(sum(order_tax), 0) as order_tax, COALESCE(sum(total), 0) as total, COALESCE(sum(grand_total), 0) as grand_total, COALESCE(sum(total_tax), 0) as tax, COALESCE(sum(total_discount), 0) as discount, COALESCE(sum(paid), 0) as paid", FALSE)
            ->group_by("DATE_FORMAT(date, '%m')")
            ->order_by("DATE_FORMAT(date, '%m') ASC");
        }

        $this->db->like('date', "{$year}", 'after');
        if ($this->session->userdata('store_id')) {
            $this->db->where('store_id', $this->session->userdata('store_id'));
        }
        $q = $this->db->get('sales');
        if($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function getTotalCustomerSales($customer_id, $user = NULL, $start_date = NULL, $end_date = NULL) {
        $this->db->select('COUNT(id) as number, sum(grand_total) as amount, sum(paid) as paid');
        if ($start_date && $end_date) {
            $this->db->where('date >=', $start_date);
            $this->db->where('date <=', $end_date);
        }
        if ($user) {
            $this->db->where('created_by', $user);
        }
        if ($this->session->userdata('store_id')) {
            $this->db->where('store_id', $this->session->userdata('store_id'));
        }
        $q = $this->db->get_where('sales', array('customer_id' => $customer_id));
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function getTotalSalesforCustomer($customer_id, $user = NULL, $start_date = NULL, $end_date = NULL) {
        if ($start_date && $end_date) {
            $this->db->where('date >=', $start_date);
            $this->db->where('date <=', $end_date);
        }
        if ($user) {
            $this->db->where('created_by', $user);
        }
        if ($this->session->userdata('store_id')) {
            $this->db->where('store_id', $this->session->userdata('store_id'));
        }
        $q=$this->db->get_where('sales', array('customer_id' => $customer_id));
        return $q->num_rows();
    }

    public function getTotalSalesValueforCustomer($customer_id, $user = NULL, $start_date = NULL, $end_date = NULL) {
        $this->db->select('sum(grand_total) as total');
        if($start_date && $end_date) {
            $this->db->where('date >=', $start_date);
            $this->db->where('date <=', $end_date);
        }
        if($user) {
            $this->db->where('created_by', $user);
        }
        if ($this->session->userdata('store_id')) {
            $this->db->where('store_id', $this->session->userdata('store_id'));
        }
        $q=$this->db->get_where('sales', array('customer_id' => $customer_id));
        if( $q->num_rows() > 0 ) {
            $s = $q->row();
            return $s->total;
        }
        return FALSE;
    }

    public function getAllStaff() {

        $q = $this->db->get('users');
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
    }

    public function getTotalSales($start, $end) {
        $this->db->select('count(id) as total, sum(COALESCE(grand_total, 0)) as total_amount, SUM(COALESCE(paid, 0)) as paid, SUM(COALESCE(total_tax, 0)) as tax', FALSE)
            ->where("date >= '{$start}' and date <= '{$end}'", NULL, FALSE);
        if ($this->session->userdata('store_id')) {
            $this->db->where('store_id', $this->session->userdata('store_id'));
        }
        $q = $this->db->get('sales');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function getTotalPurchases($start, $end) {
        $this->db->select('count(id) as total, sum(COALESCE(total, 0)) as total_amount', FALSE)
            ->where("date >= '{$start}' and date <= '{$end}'", NULL, FALSE);
        if ($this->session->userdata('store_id')) {
            $this->db->where('store_id', $this->session->userdata('store_id'));
        }
        $q = $this->db->get('purchases');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function getTotalExpenses($start, $end) {
        $this->db->select('count(id) as total, sum(COALESCE(amount, 0)) as total_amount', FALSE)
            ->where("date >= '{$start}' and date <= '{$end}'", NULL, FALSE);
        if ($this->session->userdata('store_id')) {
            $this->db->where('store_id', $this->session->userdata('store_id'));
        }
        $q = $this->db->get('expenses');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }
    
    
    public function getTotalInvestmentTotal($id) {
        $this->db->select('SUM(tec_purchase_items.subtotal) as amount', FALSE)
        ->join('tec_products', 'tec_purchase_items.product_id=tec_products.id', 'left')
        ->join('tec_purchases', 'tec_purchases.id=tec_purchase_items.purchase_id', 'left')
        ->join('tec_categories', 'tec_categories.id=tec_products.category_id', 'left');
        $this->db->where('tec_categories.parent_id', $id);
        $q = $this->db->get('tec_purchase_items');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }
    public function getInvestmentBalance($id) {
        $this->db->select('SUM(tec_product_store_qty.quantity)*(SUM(tec_purchase_items.subtotal)/SUM(tec_purchase_items.quantity))  as amount', FALSE)
        ->join('tec_products', 'tec_purchase_items.product_id=tec_products.id', 'left')
        ->join('tec_product_store_qty', 'tec_purchase_items.product_id=tec_product_store_qty.product_id', 'left')
        ->join('tec_purchases', 'tec_purchases.id=tec_purchase_items.purchase_id', 'left')
        ->join('tec_categories', 'tec_categories.id=tec_products.category_id', 'left');
        $this->db->where('tec_categories.parent_id', $id);
        
        $q = $this->db->get('tec_purchase_items');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }
    public function getTotalInvestmentBalance($id) {
        $this->db->select('SUM(tec_purchase_items.subtotal) as amount', FALSE)
        ->join('tec_products', 'tec_purchase_items.product_id=tec_products.id', 'left')
        ->join('tec_purchases', 'tec_purchases.id=tec_purchase_items.purchase_id', 'left')
        ->join('tec_categories', 'tec_categories.id=tec_products.category_id', 'left');
        $this->db->where('tec_categories.parent_id', $id);
        $this->db->where('MONTH(tec_purchases.date) != MONTH(CURRENT_DATE())');
        $q = $this->db->get('tec_purchase_items');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }
    public function getTotalInvestment($id) {
        $this->db->select('SUM(tec_purchase_items.subtotal) as amount', FALSE)
        ->join('tec_products', 'tec_purchase_items.product_id=tec_products.id', 'left')
        ->join('tec_purchases', 'tec_purchases.id=tec_purchase_items.purchase_id', 'left')
        ->join('tec_categories', 'tec_categories.id=tec_products.category_id', 'left');
        $this->db->where('tec_categories.parent_id', $id);
        $this->db->where('MONTH(tec_purchases.date) = MONTH(CURRENT_DATE())');
        $q = $this->db->get('tec_purchase_items');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }
    
    public function getTotalProfit($id) {
        $this->db->select('SUM(tec_sale_items.quantity*tec_sale_items.unit_price) as mayprice, SUM(tec_sale_items.quantity*tec_sale_items.cost) as maycost', FALSE)
        ->join('tec_products', 'tec_sale_items.product_id=tec_products.id', 'left')
        ->join('tec_sales', 'tec_sales.id=tec_sale_items.sale_id', 'left')
        ->join('tec_categories', 'tec_categories.id=tec_products.category_id', 'left');
        $this->db->where('tec_categories.parent_id', $id);
        $this->db->where('MONTH(tec_sales.date) = MONTH(CURRENT_DATE())');
        $q = $this->db->get('tec_sale_items');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }
    
     public function getTotalCurrentSell($id) {
        $this->db->select('SUM(tec_sale_items.quantity*tec_sale_items.unit_price) as mayprice', FALSE)
        ->join('tec_products', 'tec_sale_items.product_id=tec_products.id', 'left')
        ->join('tec_sales', 'tec_sales.id=tec_sale_items.sale_id', 'left')
        ->join('tec_categories', 'tec_categories.id=tec_products.category_id', 'left');
        $this->db->where('tec_categories.parent_id', $id);
        $this->db->where('MONTH(tec_sales.date) = MONTH(CURRENT_DATE())');
        $q = $this->db->get('tec_sale_items');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }
 public function getTotalSalesTotal($id) {
        $this->db->select('SUM(tec_sale_items.quantity*tec_sale_items.unit_price) as mayprice', FALSE)
        ->join('tec_products', 'tec_sale_items.product_id=tec_products.id', 'left')
        ->join('tec_sales', 'tec_sales.id=tec_sale_items.sale_id', 'left')
        ->join('tec_categories', 'tec_categories.id=tec_products.category_id', 'left');
        $this->db->where('tec_categories.parent_id', $id);
        $q = $this->db->get('tec_sale_items');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }
   public function getPresentProfit($year, $month) {
        if ($this->db->dbdriver == 'sqlite3') {
            $this->db->select("DATE_FORMAT(tec_sales.date, '%d') as date, (tec_sale_items.cost* tec_sale_items.quantity) as costtotal, (tec_sale_items.subtotal) as pricetotal", FALSE)
            ->join('tec_sale_items', 'tec_sale_items.sale_id = tec_sales.id', 'left')
            ->group_by("strftime('%d', tec_sales.date)");
        } else {
            $this->db->select("DATE_FORMAT(tec_sales.date, '%d') as date, (tec_sale_items.cost* tec_sale_items.quantity) as costtotal, (tec_sale_items.subtotal) as pricetotal", FALSE)
            ->join('tec_sale_items', 'tec_sale_items.sale_id = tec_sales.id', 'left')
            ->group_by("DATE_FORMAT(tec_sales.date, '%d')");
        }
        $this->db->like('tec_sales.date', "{$year}-{$month}", 'after');
        if ($this->session->userdata('store_id')) {
            $this->db->where('store_id', $this->session->userdata('store_id'));
        }
        $q = $this->db->get('sales');
        
        if($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
        
         
    }
    
    public function getDailySales($year, $month) {
        if ($this->db->dbdriver == 'sqlite3') {
            $this->db->select("strftime('%d', tec_sales.date) AS date, DATE(tec_sales.date) as fulldate, COALESCE(sum(tec_sales.product_tax), 0) as product_tax, COALESCE(sum(tec_sales.order_tax), 0) as order_tax, COALESCE(sum(tec_sales.total), 0) as total, COALESCE(sum(tec_sales.grand_total), 0) as grand_total, COALESCE(sum(tec_sales.total_tax), 0) as total_tax, COALESCE(sum(tec_sales.rounding), 0) as rounding, COALESCE(sum(tec_sales.total_discount), 0) as discount, COALESCE(sum(tec_sales.paid), 0) as paid", FALSE)
           // ->join('tec_sale_items', 'tec_sale_items.sale_id = tec_sales.id', 'left')
            ->group_by("strftime('%d', date)");
        } else {
            $this->db->select("DATE_FORMAT(date,  '%d') AS date, DATE(tec_sales.date) as fulldate, COALESCE(sum(product_tax), 0) as product_tax, COALESCE(sum(order_tax), 0) as order_tax, COALESCE(sum(total), 0) as total, COALESCE(sum(grand_total), 0) as grand_total, COALESCE(sum(total_tax), 0) as total_tax, COALESCE(sum(rounding), 0) as rounding, COALESCE(sum(total_discount), 0) as discount, COALESCE(sum(paid), 0) as paid", FALSE)
          //  ->join('tec_sale_items', 'tec_sale_items.sale_id = tec_sales.id', 'left')
            ->group_by("DATE_FORMAT(date, '%d')");
        }
        $this->db->like('tec_sales.date', "{$year}-{$month}", 'after');
        if ($this->session->userdata('store_id')) {
            $this->db->where('store_id', $this->session->userdata('store_id'));
        }
        $q = $this->db->get('sales');
        
        if($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
        return FALSE;
        
         
    }
    
       public function getTotalPresentProfit($start, $end)
    {
        
        $this->db->select('SUM(tec_sale_items.cost* tec_sale_items.quantity) as costtotal, SUM(tec_sale_items.subtotal) as pricetotal', FALSE)
        ->join('tec_sale_items', 'tec_sale_items.sale_id = tec_sales.id', 'left')
        ->where("tec_sales.date >= '{$start}' and tec_sales.date <= '{$end}'", NULL, FALSE);
        
        if ($this->session->userdata('store_id')) {
            $this->db->where('store_id', $this->session->userdata('store_id'));
        }
        
        $q = $this->db->get('sales');
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    
    }
    
  
}
